/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.RandomXS128;
import java.util.Random;

public final class MathUtils {
    public static final float nanoToSec = 1.0E-9f;
    public static final float FLOAT_ROUNDING_ERROR = 1.0E-6f;
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float E = (float)Math.E;
    private static final int SIN_BITS = 14;
    private static final int SIN_MASK = 16383;
    private static final int SIN_COUNT = 16384;
    private static final float radFull = (float)Math.PI * 2;
    private static final float degFull = 360.0f;
    private static final float radToIndex = 2607.5945f;
    private static final float degToIndex = 45.511112f;
    public static final float radiansToDegrees = 57.295776f;
    public static final float radDeg = 57.295776f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final float degRad = (float)Math.PI / 180;
    public static Random random = new RandomXS128();
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final double CEIL = 0.9999999;
    private static final double BIG_ENOUGH_CEIL = 16384.999999999996;
    private static final double BIG_ENOUGH_ROUND = 16384.5;

    public static float sin(float radians) {
        return Sin.table[(int)(radians * 2607.5945f) & 0x3FFF];
    }

    public static float cos(float radians) {
        return Sin.table[(int)((radians + 1.5707964f) * 2607.5945f) & 0x3FFF];
    }

    public static float sinDeg(float degrees) {
        return Sin.table[(int)(degrees * 45.511112f) & 0x3FFF];
    }

    public static float cosDeg(float degrees) {
        return Sin.table[(int)((degrees + 90.0f) * 45.511112f) & 0x3FFF];
    }

    public static float atan2(float y, float x) {
        if (x == 0.0f) {
            if (y > 0.0f) {
                return 1.5707964f;
            }
            if (y == 0.0f) {
                return 0.0f;
            }
            return -1.5707964f;
        }
        float z = y / x;
        if (Math.abs(z) < 1.0f) {
            float atan = z / (1.0f + 0.28f * z * z);
            if (x < 0.0f) {
                return y < 0.0f ? atan - (float)Math.PI : atan + (float)Math.PI;
            }
            return atan;
        }
        float atan = 1.5707964f - z / (z * z + 0.28f);
        return y < 0.0f ? atan - (float)Math.PI : atan;
    }

    public static int random(int range2) {
        return random.nextInt(range2 + 1);
    }

    public static int random(int start, int end) {
        return start + random.nextInt(end - start + 1);
    }

    public static long random(long range2) {
        return (long)(random.nextDouble() * (double)range2);
    }

    public static long random(long start, long end) {
        return start + (long)(random.nextDouble() * (double)(end - start));
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static boolean randomBoolean(float chance) {
        return MathUtils.random() < chance;
    }

    public static float random() {
        return random.nextFloat();
    }

    public static float random(float range2) {
        return random.nextFloat() * range2;
    }

    public static float random(float start, float end) {
        return start + random.nextFloat() * (end - start);
    }

    public static int randomSign() {
        return 1 | random.nextInt() >> 31;
    }

    public static float randomTriangular() {
        return random.nextFloat() - random.nextFloat();
    }

    public static float randomTriangular(float max2) {
        return (random.nextFloat() - random.nextFloat()) * max2;
    }

    public static float randomTriangular(float min2, float max2) {
        return MathUtils.randomTriangular(min2, max2, (min2 + max2) * 0.5f);
    }

    public static float randomTriangular(float min2, float max2, float mode) {
        float d;
        float u = random.nextFloat();
        if (u <= (mode - min2) / (d = max2 - min2)) {
            return min2 + (float)Math.sqrt(u * d * (mode - min2));
        }
        return max2 - (float)Math.sqrt((1.0f - u) * d * (max2 - mode));
    }

    public static int nextPowerOfTwo(int value2) {
        if (value2 == 0) {
            return 1;
        }
        --value2;
        value2 |= value2 >> 1;
        value2 |= value2 >> 2;
        value2 |= value2 >> 4;
        value2 |= value2 >> 8;
        value2 |= value2 >> 16;
        return value2 + 1;
    }

    public static boolean isPowerOfTwo(int value2) {
        return value2 != 0 && (value2 & value2 - 1) == 0;
    }

    public static short clamp(short value2, short min2, short max2) {
        if (value2 < min2) {
            return min2;
        }
        if (value2 > max2) {
            return max2;
        }
        return value2;
    }

    public static int clamp(int value2, int min2, int max2) {
        if (value2 < min2) {
            return min2;
        }
        if (value2 > max2) {
            return max2;
        }
        return value2;
    }

    public static long clamp(long value2, long min2, long max2) {
        if (value2 < min2) {
            return min2;
        }
        if (value2 > max2) {
            return max2;
        }
        return value2;
    }

    public static float clamp(float value2, float min2, float max2) {
        if (value2 < min2) {
            return min2;
        }
        if (value2 > max2) {
            return max2;
        }
        return value2;
    }

    public static double clamp(double value2, double min2, double max2) {
        if (value2 < min2) {
            return min2;
        }
        if (value2 > max2) {
            return max2;
        }
        return value2;
    }

    public static float lerp(float fromValue, float toValue, float progress) {
        return fromValue + (toValue - fromValue) * progress;
    }

    public static float lerpAngle(float fromRadians, float toRadians, float progress) {
        float delta = (toRadians - fromRadians + (float)Math.PI * 2 + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI;
        return (fromRadians + delta * progress + (float)Math.PI * 2) % ((float)Math.PI * 2);
    }

    public static float lerpAngleDeg(float fromDegrees, float toDegrees, float progress) {
        float delta = (toDegrees - fromDegrees + 360.0f + 180.0f) % 360.0f - 180.0f;
        return (fromDegrees + delta * progress + 360.0f) % 360.0f;
    }

    public static int floor(float value2) {
        return (int)((double)value2 + 16384.0) - 16384;
    }

    public static int floorPositive(float value2) {
        return (int)value2;
    }

    public static int ceil(float value2) {
        return (int)((double)value2 + 16384.999999999996) - 16384;
    }

    public static int ceilPositive(float value2) {
        return (int)((double)value2 + 0.9999999);
    }

    public static int round(float value2) {
        return (int)((double)value2 + 16384.5) - 16384;
    }

    public static int roundPositive(float value2) {
        return (int)(value2 + 0.5f);
    }

    public static boolean isZero(float value2) {
        return Math.abs(value2) <= 1.0E-6f;
    }

    public static boolean isZero(float value2, float tolerance) {
        return Math.abs(value2) <= tolerance;
    }

    public static boolean isEqual(float a, float b) {
        return Math.abs(a - b) <= 1.0E-6f;
    }

    public static boolean isEqual(float a, float b, float tolerance) {
        return Math.abs(a - b) <= tolerance;
    }

    public static float log(float a, float value2) {
        return (float)(Math.log(value2) / Math.log(a));
    }

    public static float log2(float value2) {
        return MathUtils.log(2.0f, value2);
    }

    private static class Sin {
        static final float[] table;

        private Sin() {
        }

        static {
            int i;
            table = new float[16384];
            for (i = 0; i < 16384; ++i) {
                Sin.table[i] = (float)Math.sin(((float)i + 0.5f) / 16384.0f * ((float)Math.PI * 2));
            }
            for (i = 0; i < 360; i += 90) {
                Sin.table[(int)((float)i * 45.511112f) & 0x3FFF] = (float)Math.sin((float)i * ((float)Math.PI / 180));
            }
        }
    }
}

